/********************************************************************************************************************************
 * Copyright 2021-2022 MinusOne, Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 ********************************************************************************************************************************/
package m1.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;

public abstract class Transform {
	public static final ObjectMapper MAPPER = new ObjectMapper();

	public static Object getNestedProperty(Map m, Object... dimensions) {
		if(m == null) {
			return null;
		} else if(dimensions == null || dimensions.length == 0) {
			return m; // weird, but what were you trying to do here?
		} else if(dimensions.length == 1) {
			return m.get(dimensions[0]);
		} else {
			return getNestedProperty((Map) m.get(dimensions[0]), Arrays.copyOfRange(dimensions, 1, dimensions.length));
		}
	}
	public static Map put(Map map, Object key, Object value) {
		map.put(key, value);
		return map;
	}
	public static Map map(String json) throws JsonMappingException, JsonProcessingException {
		return MAPPER.readValue(json, HashMap.class);
	}

	public static List list(String json) throws JsonMappingException, JsonProcessingException {
		return MAPPER.readValue(json, List.class);
	}

	public static <T> Collection<Collection<T>> page(Collection<T> coll, int pageSize) {
		Collection<Collection<T>> result = new ArrayList<>();

		Collection<T> current = null;
		for(T el : coll) {
			if(current == null || current.size() == pageSize) {
				current = new ArrayList<>();
				result.add(current);
			}
			current.add(el);
		}

		return result;
	}
}
