/********************************************************************************************************************************
 * Copyright 2021-2022 MinusOne, Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 ********************************************************************************************************************************/
package m1.util;

import java.io.File;
import java.io.FileInputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermissions;

public abstract class Local {
	public static String readFile(String file) throws Exception {
		try (FileInputStream f = new FileInputStream(new File(file))) {
			return new String(f.readAllBytes());
		}
	}
	public static void ensureDirectory(String dir) throws Exception {
		try {
			Files.createDirectory(Path.of(dir), PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------")));
		} catch(UnsupportedOperationException e) {
			try {
				Files.createDirectory(Path.of(dir));
				File f = new File(dir);
				f.setReadable(true, true);
				f.setWritable(true, true);
			} catch(FileAlreadyExistsException e2) {
			}
		} catch(FileAlreadyExistsException e) {
		}
	}
}
