/********************************************************************************************************************************
 * Copyright 2021-2022 MinusOne, Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 ********************************************************************************************************************************/
package m1;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.databind.ObjectMapper;
import m1.util.Local;

public class M1LocalCredentialStore extends M1CredentialStore {
	protected static final String DIR_M1 = System.getProperty("user.home") + "/.m1";
	protected static final String FILE_CREDENTIAL = M1LocalCredentialStore.DIR_M1 + "/.credentials";
	
	protected Map credentials() throws Exception {
		Map<String, Map> credentials = null;
		try {
			credentials = new ObjectMapper().readValue(Local.readFile(FILE_CREDENTIAL), Map.class);
		} catch(Exception e) {
			// mostly due to missing file
		}
		return credentials == null ? new HashMap() : credentials;
	}
	
	protected void writeCredentials(Map credentials) throws Exception {
		Local.ensureDirectory(DIR_M1);
		File file = new File(FILE_CREDENTIAL);
		try (FileOutputStream f = new FileOutputStream(file)) {
			f.write(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsBytes(credentials));
		}
		file.setReadable(false, false);
		file.setWritable(false, false);
		file.setReadable(true, true);
		file.setWritable(true, true);
	}
}
