/********************************************************************************************************************************
 * Copyright 2021-2022 MinusOne, Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 ********************************************************************************************************************************/
package m1;

import java.util.HashMap;
import java.util.Map;
import m1.util.Transform;

public abstract class M1CredentialStore {
	public static final String USERNAME = "username";
	public static final String PASSWORD = "password";
	public static final String TOKEN = "token";

	protected abstract Map credentials() throws Exception;
	protected abstract void writeCredentials(Map credentials) throws Exception;

	protected Map credential(String envName) throws Exception {
		Map cred = (Map) credentials().get(M1.envName(envName));
		return cred == null ? new HashMap() : cred;
	}
	protected void setCredential(String envName, Map credential) throws Exception {
		Map creds = credentials();
		creds.put(M1.envName(envName), credential);
		writeCredentials(creds);
	}

	// Auth helpers
	public String token() throws Exception {
		return token(null);
	}
	public String token(String envName) throws Exception {
		return (String) Transform.getNestedProperty(credentials(), envName == null ? M1.OPS : envName, TOKEN);
	}
	public void updateToken(String envName, String token, String username, String password) throws Exception {
		Map creds = credentials();
		Map cred = credential(envName);
		cred.put(TOKEN, token);
		cred.put(M1CredentialStore.USERNAME, username);
		cred.put(M1CredentialStore.PASSWORD, password);
		creds.put(M1.envName(envName), cred);
		writeCredentials(creds);
	}
}
