/*
 * Decompiled with CFR 0.152.
 */
package m1.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Transform {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static Object getNestedProperty(Map m, Object ... dimensions) {
        if (m == null) {
            return null;
        }
        if (dimensions == null || dimensions.length == 0) {
            return m;
        }
        if (dimensions.length == 1) {
            return m.get(dimensions[0]);
        }
        return Transform.getNestedProperty((Map)m.get(dimensions[0]), Arrays.copyOfRange(dimensions, 1, dimensions.length));
    }

    public static Map put(Map map, Object key, Object value) {
        map.put(key, value);
        return map;
    }

    public static Map map(String json) throws JsonMappingException, JsonProcessingException {
        return MAPPER.readValue(json, HashMap.class);
    }

    public static List list(String json) throws JsonMappingException, JsonProcessingException {
        return MAPPER.readValue(json, List.class);
    }

    public static <T> Collection<Collection<T>> page(Collection<T> coll, int pageSize) {
        ArrayList<Collection<T>> result = new ArrayList<Collection<T>>();
        ArrayList<T> current = null;
        for (T el : coll) {
            if (current == null || current.size() == pageSize) {
                current = new ArrayList<T>();
                result.add(current);
            }
            current.add(el);
        }
        return result;
    }
}

