/*
 * Decompiled with CFR 0.152.
 */
package m1.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import m1.util.Transform;

public abstract class Query {
    public static final int MAX_TERMS = 100000;
    protected static final Set<Character> CHARS_TO_ESCAPE = new TreeSet<Character>(){
        {
            this.add(Character.valueOf('+'));
            this.add(Character.valueOf('&'));
            this.add(Character.valueOf('|'));
            this.add(Character.valueOf('!'));
            this.add(Character.valueOf('('));
            this.add(Character.valueOf(')'));
            this.add(Character.valueOf('['));
            this.add(Character.valueOf(']'));
            this.add(Character.valueOf('{'));
            this.add(Character.valueOf('}'));
            this.add(Character.valueOf('^'));
            this.add(Character.valueOf('\"'));
            this.add(Character.valueOf('~'));
            this.add(Character.valueOf('*'));
            this.add(Character.valueOf('?'));
            this.add(Character.valueOf(':'));
            this.add(Character.valueOf('/'));
            this.add(Character.valueOf('\\'));
        }
    };

    public static String or(Map<String, Object> m) {
        return Query.conjunct(m, " OR ");
    }

    public static String and(Map<String, Object> m) {
        return Query.conjunct(m, " AND ");
    }

    public static String clause(String property, Object values) {
        if (values instanceof Collection) {
            List<Object> nonNullValues = ((Collection)values).stream().filter(v -> v != null).toList();
            return nonNullValues.isEmpty() ? null : Query.valuesTerm(property, nonNullValues);
        }
        return values == null ? null : String.format("%s:%s", property, Query.queryValue((String)values));
    }

    public static String valuesTerm(String property, Collection<String> values) {
        return "(" + Transform.page(values, 100000).stream().map(valuesPage -> String.format("%s:(%s)", property, Query.orValues(valuesPage))).collect(Collectors.joining(" OR ")) + ")";
    }

    private static String orValues(Collection<String> values) {
        return values.stream().map(v -> Query.queryValue(v)).collect(Collectors.joining("||"));
    }

    public static String queryValue(String val) {
        if (val == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        for (int i = 0; i < val.length(); ++i) {
            if (CHARS_TO_ESCAPE.contains(Character.valueOf(val.charAt(i)))) {
                sb.append('\\');
            }
            if ('+' == val.charAt(i)) {
                sb.append("%2B");
                continue;
            }
            if ('%' == val.charAt(i)) {
                sb.append("%25");
                continue;
            }
            if ('&' == val.charAt(i)) {
                sb.append("%26");
                continue;
            }
            sb.append(val.charAt(i));
        }
        sb.append('\"');
        return sb.toString();
    }

    private static String conjunct(Map<String, Object> m, String conjunction) {
        return m.entrySet().stream().map(es -> Query.clause((String)es.getKey(), es.getValue())).filter(clause -> clause != null).collect(Collectors.joining(conjunction));
    }
}

