/*
 * Decompiled with CFR 0.152.
 */
package m1.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import m1.M1Response;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.GzipCompressingEntity;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.Timeout;

public abstract class Http {
    public static final String GET = "GET";
    public static final String POST = "POST";
    protected static final long INTERVAL_RETRY = 30L;

    public static String request(String method, String url, Map<String, String> headers, Map params) throws Exception {
        try (M1Response response = Http.requestStream(method, url, headers, params);){
            String string = response.getString();
            return string;
        }
    }

    public static M1Response requestStream(String method, String url, Map<String, String> headers, Map params) throws Exception {
        HttpUriRequestBase req;
        switch (method) {
            case "POST": {
                req = new HttpPost(url);
                HttpEntity payload = Http.form(params);
                if (Http.shouldCompressPayload(headers)) {
                    payload = new GzipCompressingEntity(Http.form(params));
                }
                req.setEntity(payload);
                break;
            }
            default: {
                req = new HttpGet(Http.urlWithParams(url, params));
            }
        }
        return Http.http(req, headers);
    }

    protected static URI urlWithParams(String url, Map<String, String> params) throws Exception {
        URIBuilder out = new URIBuilder(url);
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                out.setParameter(e.getKey(), e.getValue());
            }
        }
        return out.build();
    }

    protected static boolean shouldCompressPayload(Map<String, String> headers) {
        if (headers != null) {
            for (String header : headers.keySet()) {
                if (!"Content-Encoding".equals(header) || !"gzip".equals(headers.get(header))) continue;
                return true;
            }
        }
        return false;
    }

    protected static M1Response http(ClassicHttpRequest req, Map<String, String> headers) throws Exception {
        if (headers != null) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                req.addHeader(e.getKey(), e.getValue());
            }
        }
        RequestConfig rc = RequestConfig.custom().setResponseTimeout(Timeout.DISABLED).setConnectionRequestTimeout(Timeout.DISABLED).setConnectTimeout(Timeout.DISABLED).build();
        HttpClientBuilder builder = HttpClientBuilder.create().setDefaultRequestConfig(rc);
        try {
            CloseableHttpClient hc = builder.build();
            CloseableHttpResponse r = hc.execute(req);
            HttpEntity e = r.getEntity();
            if (Arrays.asList(502, 503, 504).contains(r.getCode())) {
                TimeUnit.SECONDS.sleep(30L);
                return Http.http(req, headers);
            }
            if (r.getCode() == 401) {
                throw new AuthenticationException("Token invalid or incorrect login information.");
            }
            if (!Arrays.asList(200, 204).contains(r.getCode())) {
                throw new Exception(e == null ? "" : EntityUtils.toString(e));
            }
            return new M1Response(r, hc);
        }
        catch (UnknownHostException un) {
            TimeUnit.SECONDS.sleep(30L);
            return Http.http(req, headers);
        }
    }

    protected static UrlEncodedFormEntity form(Map<String, Object> m) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        LinkedList<BasicNameValuePair> params = new LinkedList<BasicNameValuePair>();
        for (Map.Entry<String, Object> e : m.entrySet()) {
            if (e.getValue() == null) continue;
            if (e.getValue() instanceof Collection || e.getValue() instanceof Map) {
                params.add(new BasicNameValuePair(e.getKey(), mapper.writeValueAsString(e.getValue())));
                continue;
            }
            params.add(new BasicNameValuePair(e.getKey(), e.getValue().toString()));
        }
        return new UrlEncodedFormEntity((List<? extends NameValuePair>)params);
    }
}

