/*
 * Decompiled with CFR 0.152.
 */
package m1;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import m1.M1;
import m1.util.Transform;

public class M1Ops {
    protected M1 m1;
    protected String opsName;

    public M1Ops() {
    }

    public M1Ops(String type) {
        this();
        this.m1 = new M1(type);
    }

    public M1Ops(M1 m1) {
        this(m1, "ops");
    }

    public M1Ops(M1 m1, String opsName) {
        this();
        this.m1 = m1;
        this.opsName = opsName;
    }

    public void setM1(M1 m1) {
        this.m1 = m1;
    }

    public M1 getM1() {
        return this.m1;
    }

    public void signup() throws Exception {
        System.out.print("Username: ");
        String username = System.console().readLine();
        System.out.print("Password: ");
        String password = new String(System.console().readPassword());
        this.m1.POST(this.opsName, M1.url(this.opsName, "signup"), Map.of("username", username, "password", password));
        this.m1.auth(this.opsName, username, password);
    }

    public void deploy(String envName, Map descriptor) throws Exception {
        System.out.println("Creating environment...");
        String e = this.createEnvironment(envName, descriptor);
        System.out.println(e);
        Map env = Transform.map(e);
        System.out.println("Initializing...");
        TimeUnit.SECONDS.sleep(30L);
        this.m1.init(envName, descriptor, env);
        this.deployStores(descriptor, envName);
        this.m1.waitForHealth(envName);
        System.out.println("Configuring...");
        this.m1.configure(envName, (List)Transform.getNestedProperty(descriptor, "environment", "configure"));
    }

    public String createEnvironment(String envName, Map descriptor) throws Exception {
        return this.m1.POST(this.opsName, M1.url(this.opsName, "env/create"), Transform.put((Map)Transform.getNestedProperty(descriptor, "environment", "create"), "env", envName));
    }

    public void deployStores(Map descriptor, String envName) throws Exception {
        this.createStores(envName, (List)Transform.getNestedProperty(descriptor, "environment", "stores"), "store");
        this.createStores(envName, (List)Transform.getNestedProperty(descriptor, "environment", "sessionStores"), "session");
    }

    public void createStores(String env, List<Map> stores, String type) throws Exception {
        for (Map store : stores) {
            store.put("env", env);
            this.createStore(env, type, store);
        }
    }

    public void createStore(String envName, String type, Map store) throws Exception {
        this.m1.POST(this.opsName, M1.url(this.opsName, "env/" + type + "/create"), store);
        this.m1.POST(envName, M1.url(envName) + "/" + type + "/add", store);
    }

    public void dropStore(String type, String env, String store) throws Exception {
        this.m1.POST(env, M1.url(env) + "/" + type + "/drop", Map.of("store", store));
        this.m1.POST(this.opsName, M1.url(this.opsName, "env/" + type + "/destroy"), Map.of("env", env, "store", store));
    }

    public void renameStore(String type, String env, String oldStoreName, String newStoreName) throws Exception {
        this.m1.POST(env, M1.url(env) + "/" + type + "/rename", Map.of("store", oldStoreName, "name", newStoreName));
        this.m1.POST(this.opsName, M1.url(this.opsName, "env/" + type + "/rename"), Map.of("env", env, "store", oldStoreName, "name", newStoreName));
    }
}

