/*
 * Decompiled with CFR 0.152.
 */
package m1;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import m1.M1CredentialStore;
import m1.util.Local;

public class M1LocalCredentialStore
extends M1CredentialStore {
    protected static final String DIR_M1 = System.getProperty("user.home") + "/.m1";
    protected static final String FILE_CREDENTIAL = DIR_M1 + "/.credentials";

    @Override
    protected Map credentials() throws Exception {
        Map credentials = null;
        try {
            credentials = new ObjectMapper().readValue(Local.readFile(FILE_CREDENTIAL), Map.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return credentials == null ? new HashMap() : credentials;
    }

    @Override
    protected void writeCredentials(Map credentials) throws Exception {
        Local.ensureDirectory(DIR_M1);
        File file = new File(FILE_CREDENTIAL);
        try (FileOutputStream f = new FileOutputStream(file);){
            f.write(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsBytes(credentials));
        }
        file.setReadable(false, false);
        file.setWritable(false, false);
        file.setReadable(true, true);
        file.setWritable(true, true);
    }
}

