/*
 * Decompiled with CFR 0.152.
 */
package m1;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import m1.M1Response;
import m1.util.Transform;

public class M1DocumentIterator
implements Iterator<Map>,
AutoCloseable {
    protected final M1Response m1response;
    protected final BufferedReader reader;
    protected final InputStreamReader inputStreamReader;
    protected String currentLine;
    protected final Map responseMetadata;

    public M1DocumentIterator(M1Response m1response) throws Exception {
        this.m1response = m1response;
        this.inputStreamReader = new InputStreamReader(m1response.getInputStream(), StandardCharsets.UTF_8);
        this.reader = new BufferedReader(this.inputStreamReader);
        this.advance();
        this.responseMetadata = Transform.map(this.currentLine);
        this.advance();
    }

    public Map getResponseMetadata() {
        return this.responseMetadata;
    }

    public int getNumFound() {
        return (Integer)Transform.getNestedProperty(this.responseMetadata, "response", "numFound");
    }

    protected void advance() {
        try {
            this.currentLine = this.reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentLine != null;
    }

    @Override
    public Map next() {
        try {
            Map toReturn = Transform.map(this.currentLine);
            this.advance();
            return toReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        for (AutoCloseable closeable : Arrays.asList(this.reader, this.m1response, this.inputStreamReader)) {
            try {
                closeable.close();
            }
            catch (Exception exception) {}
        }
    }
}

