/*
 * Decompiled with CFR 0.152.
 */
package m1;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import m1.M1CredentialStore;
import m1.M1DocumentIterator;
import m1.M1LocalCredentialStore;
import m1.M1RAMCredentialStore;
import m1.M1Response;
import m1.util.Http;
import m1.util.Local;
import m1.util.Transform;
import org.apache.hc.client5.http.auth.AuthenticationException;

public class M1 {
    public static final String HEADER_AUTH = "m1-auth-token";
    public static final String M1_DOMAIN = ".minusonedb.com";
    public static final String LOCAL_OPS = "localops";
    public static final String LOCAL_OPS_URL = "http://localhost:8000";
    public static final String OPS = "ops";
    public static final String OPS_URL = "https://ops.minusonedb.com";
    protected static final String TYPE_LOCAL = "local";
    private M1CredentialStore store;
    protected static final String HEALTH_OK = "PASSED";
    protected static final Long INTERVAL_WAIT = 30L;
    protected static final String FILE_INDICATOR = "@";

    public M1() {
    }

    public M1(String type) {
        this();
        this.setType(type);
    }

    public void setType(String type) {
        this.store = TYPE_LOCAL.equals(type) ? new M1LocalCredentialStore() : new M1RAMCredentialStore();
    }

    public String auth(String envName, String username, String password) throws Exception {
        String token = Http.request("POST", M1.url(envName) + "/auth", null, Map.of("username", username, "password", password));
        if (this.store != null) {
            this.store.updateToken(envName, token, username, password);
        }
        return token;
    }

    protected void updateToken(String envName) throws Exception {
        Map cred = this.store.credential(envName);
        if (cred == null) {
            throw new Exception(String.format("No credentials present for %s; check for typos or use 'm1 auth %s' to store credentials.", envName, envName));
        }
        this.auth(envName, (String)cred.get("username"), (String)cred.get("password"));
    }

    protected void call(String envName, Map<String, Map> svc) throws Exception {
        for (Map.Entry<String, Map> call : svc.entrySet()) {
            this.POST(envName, M1.url(envName, call.getKey()), M1.resolveFiles(call.getValue()));
        }
    }

    public String call(String envName, String method, String svc, Map params) throws Exception {
        try (M1Response m1response = this.request(method, envName, M1.url(envName, svc), M1.resolveFiles(params));){
            String string = m1response.getString();
            return string;
        }
    }

    public String call(String envName, String method, String svc, Map params, Map<String, String> extraHeaders) throws Exception {
        try (M1Response m1response = this.request(method, envName, M1.url(envName, svc), M1.resolveFiles(params), extraHeaders);){
            String string = m1response.getString();
            return string;
        }
    }

    protected void init(String envName, Map descriptor, Map env) throws Exception {
        String username = (String)Transform.getNestedProperty(descriptor, "environment", "init", "username");
        String password = (String)Transform.getNestedProperty(descriptor, "environment", "init", "password");
        String bucket = (String)Transform.getNestedProperty(env, "bucket");
        Http.request("POST", M1.url(envName) + "/init", null, Map.of("username", username, "password", password, "bucket", bucket));
        TimeUnit.SECONDS.sleep(10L);
        this.auth(envName, username, password);
    }

    public M1DocumentIterator getDocumentIterator(String envName, Map queryParams) throws Exception {
        queryParams = new HashMap<String, String>(queryParams);
        queryParams.put("format", "jsonl");
        return new M1DocumentIterator(this.request("POST", envName, M1.url(envName, "query"), queryParams));
    }

    protected boolean health(String envName) throws Exception {
        String rsp = this.GET(envName, M1.url(envName) + "/health");
        Map health = Transform.map(rsp);
        return HEALTH_OK.equals(Transform.getNestedProperty(health, "overall", "status"));
    }

    protected void waitForHealth(String envName) throws Exception {
        TimeUnit.SECONDS.sleep(60L);
        while (!this.health(envName)) {
            TimeUnit.SECONDS.sleep(INTERVAL_WAIT);
        }
    }

    protected void configure(String envName, List<Map<String, Map>> ops) throws Exception {
        for (Map<String, Map> m : ops) {
            this.call(envName, m);
        }
    }

    public String GET(String envName, String url) throws Exception {
        try (M1Response m1response = this.request("GET", envName, url, null);){
            String string = m1response.getString();
            return string;
        }
    }

    public String POST(String envName, String url, Map params) throws Exception {
        try (M1Response m1response = this.request("POST", envName, url, params);){
            String string = m1response.getString();
            return string;
        }
    }

    public M1Response request(String method, String envName, String url, Map params) throws Exception {
        return this.request(method, envName, url, params, Collections.EMPTY_MAP);
    }

    public M1Response request(String method, String envName, String url, Map params, Map<String, String> extraHeaders) throws Exception {
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put(HEADER_AUTH, this.store.token(envName));
            for (String header : extraHeaders.keySet()) {
                headers.put(header, extraHeaders.get(header));
            }
            return Http.requestStream(method, url, headers, params);
        }
        catch (AuthenticationException ae) {
            this.updateToken(envName);
            return this.request(method, envName, url, params, extraHeaders);
        }
    }

    public static String envName(String envName) {
        return envName == null ? OPS : envName;
    }

    public static String url(String envName) {
        if (envName == null || OPS.equals(envName)) {
            return OPS_URL;
        }
        if ("localdev".equals(envName)) {
            return "http://localhost:8100";
        }
        if (LOCAL_OPS.equals(envName)) {
            return LOCAL_OPS_URL;
        }
        return "https://" + envName + M1_DOMAIN;
    }

    public static String url(String envName, String svc) {
        return M1.url(envName) + "/" + (svc != null ? svc : "");
    }

    protected static Map resolveFiles(Map<String, Object> params) throws Exception {
        HashMap<String, Object> newParams = new HashMap<String, Object>();
        if (params != null) {
            for (String key : params.keySet()) {
                Object value = params.get(key);
                if (value instanceof String && ((String)value).startsWith(FILE_INDICATOR)) {
                    value = Local.readFile(((String)value).substring(FILE_INDICATOR.length()));
                }
                newParams.put(key, value);
            }
        }
        return newParams;
    }
}

