/*
 * Decompiled with CFR 0.152.
 */
package m1;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import m1.M1;
import m1.M1Ops;
import m1.util.Local;
import m1.util.Transform;

public class CLI {
    public static final List<String> ORCHESTRATE_CMDS = Arrays.asList("deploy", "addStores", "dropStore", "renameStore");
    protected static final List<String> SVC_MIXED = Arrays.asList("system", "init");
    protected static final List<String> SVC_ENDPOINT_GET = Arrays.asList("ping", "list", "get", "schema", "health", "next");

    public static void main(String[] args) throws Exception {
        try {
            M1 m1 = new M1("local");
            if (args.length < 1) {
                System.out.println("Usage: m1 <cmd> <args...>");
                System.out.println("More help available at https://docs.minusonedb.com/#m1-client");
                return;
            }
            switch (args[0]) {
                case "auth": {
                    CLI.auth(m1, args.length > 1 && !"ops".equals(args[1]) ? args[1] : null);
                    break;
                }
                case "signup": {
                    new M1Ops(m1, "ops").signup();
                    break;
                }
                case "orchestrate": {
                    if (ORCHESTRATE_CMDS.contains(args[1])) {
                        CLI.doOrchestrate(new M1Ops(m1), Arrays.copyOfRange(args, 1, args.length));
                        break;
                    }
                    if (ORCHESTRATE_CMDS.contains(args[2])) {
                        CLI.doOrchestrate(new M1Ops(m1, args[1]), Arrays.copyOfRange(args, 2, args.length));
                        break;
                    }
                    System.out.println("orchestrate usage:");
                    System.out.println("m1 orchestrate deploy <envName> <m1-template-file>");
                    System.out.println("m1 orchestrate addStores <envName> <m1-template-file>");
                    System.out.println("m1 orchestrate dropStore store|session <envName> <storeName>");
                    break;
                }
                default: {
                    String out = m1.call(args[0], CLI.method(args), args[1], CLI.params(Arrays.copyOfRange(args, 2, args.length)));
                    System.out.println(out == null ? "" : out);
                    break;
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void doOrchestrate(M1Ops ops, String[] args) throws Exception {
        switch (args[0]) {
            case "deploy": {
                Map descriptor = Transform.map(Local.readFile(args[2]));
                ops.deploy(args[1], descriptor);
                String username = (String)Transform.getNestedProperty(descriptor, "environment", "init", "username");
                String password = (String)Transform.getNestedProperty(descriptor, "environment", "init", "password");
                ops.getM1().auth(args[1], username, password);
                break;
            }
            case "addStores": {
                ops.deployStores(Transform.map(Local.readFile(args[2])), args[1]);
                break;
            }
            case "renameStore": {
                ops.renameStore(args[1], args[2], args[3], args[4]);
                break;
            }
            case "dropStore": {
                ops.dropStore(args[1], args[2], args[3]);
                break;
            }
            default: {
                throw new Exception(String.format("Unknown orchestrate command `%s`; must be one of deploy, addStores, or dropStore", args[0]));
            }
        }
    }

    protected static void auth(M1 m1, String envName) throws Exception {
        System.out.print("Username: ");
        String username = System.console().readLine();
        System.out.print("Password: ");
        String password = new String(System.console().readPassword());
        m1.auth(envName, username, password);
    }

    public static String method(String[] args) throws Exception {
        if (args.length < 2) {
            throw new Exception("No method provided. Please consult https://docs.minusonedb.com for guidance.");
        }
        String[] parts = args[1].split("/");
        String end = parts[parts.length - 1];
        if (SVC_MIXED.contains(parts[0])) {
            return args.length > 2 ? "POST" : "GET";
        }
        if (SVC_ENDPOINT_GET.contains(end)) {
            return "GET";
        }
        return "POST";
    }

    protected static Map<String, Object> params(String[] args) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].indexOf(45) != 0) {
                throw new Exception("Looks like you are missing a parameter argument. Parameters must start with '-'.");
            }
            if (args.length < i + 2) {
                throw new Exception("Looks like you are missing a parameter value. Odd number of arguments provided.");
            }
            params.put(args[i].substring(1), args[i + 1]);
        }
        return params;
    }
}

